/*
 * Decompiled with CFR 0.152.
 */
package org.retentionprediction;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.help.HelpSet;
import javax.swing.JApplet;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.retentionprediction.AutoScaleEvent;
import org.retentionprediction.AutoScaleListener;
import org.retentionprediction.Compound;
import org.retentionprediction.Globals;
import org.retentionprediction.InterpolationFunction;
import org.retentionprediction.PreloadedValuesDialog;
import org.retentionprediction.TopPanel;
import org.retentionprediction.TopPanel2;

public class RetentionPredictorApplet
extends JApplet
implements ActionListener,
KeyListener,
FocusListener,
ListSelectionListener,
AutoScaleListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    TopPanel contentPane = null;
    TopPanel2 contentPane2 = null;
    public int m_iStationaryPhase = 0;
    public double m_dStartingComposition = 0.1;
    public double m_dEndingComposition = 1.0;
    public double m_dGradientTime = 20.0;
    public double m_dFlowRate = 0.2;
    public int m_iNumPoints = 3000;
    public Vector<Object[]> m_vectCalSolutes = new Vector();
    private Task task;
    private TaskPredict taskPredict;
    public int m_iStage = 1;
    public double m_dtstep = 0.01;
    public InterpolationFunction m_InterpolatedGradient;
    public double[][] m_dGradientArray;
    public InterpolationFunction m_InterpolatedFlowRate;
    public double[][] m_dFlowRateArray;
    public InterpolationFunction[] m_IsocraticDataInterpolated;
    public InterpolationFunction m_Vm;
    public int m_iInterpolatedGradientSeries = 0;
    public int m_iGradientMarkerSeries = 0;
    public int m_iInterpolatedFlowSeries = 0;
    public int m_iFlowRateMarkerSeries = 0;
    public double m_dPlotXMax = 0.0;
    public double m_dPlotXMax2 = 0.0;
    public Vector<Compound> m_vectCompound = new Vector();

    public RetentionPredictorApplet() {
        this.setPreferredSize(new Dimension(900, 650));
    }

    @Override
    public void init() {
        String helpHS = "org/retentionprediction/help/RetentionPredictorHelp.hs";
        ClassLoader cl = TopPanel.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
            Globals.hsMainHelpSet = new HelpSet(null, hsURL);
        }
        catch (Exception ee) {
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            return;
        }
        Globals.hbMainHelpBroker = Globals.hsMainHelpSet.createHelpBroker();
        try {
            this.createGUI();
        }
        catch (Exception e) {
            System.err.println("createGUI didn't complete successfully");
            System.err.println(e.getMessage());
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            System.err.println(e.getCause());
        }
        this.performValidations();
    }

    private void createGUI() {
        this.contentPane = new TopPanel();
        this.contentPane.setOpaque(true);
        this.setContentPane(this.contentPane);
        this.contentPane.jtxtInitialSolventComposition.addFocusListener(this);
        this.contentPane.jtxtInitialSolventComposition.addKeyListener(this);
        this.contentPane.jtxtFinalSolventComposition.addFocusListener(this);
        this.contentPane.jtxtFinalSolventComposition.addKeyListener(this);
        this.contentPane.jtxtGradientTime.addFocusListener(this);
        this.contentPane.jtxtGradientTime.addKeyListener(this);
        this.contentPane.jtxtFlowRate.addFocusListener(this);
        this.contentPane.jtxtFlowRate.addKeyListener(this);
        this.contentPane.jbtnHelp.addActionListener(this);
        this.contentPane.m_GraphControl.addAutoScaleListener(this);
        this.contentPane.m_GraphControlFlow.addAutoScaleListener(this);
        this.contentPane.tmSelectCompounds.addTableModelListener(this);
        this.contentPane.tmMeasuredRetentionTimes.addTableModelListener(this);
        this.contentPane.jbtnNextStep.addActionListener(this);
        this.contentPane.jbtnPreloadedValues.addActionListener(this);
        this.contentPane.m_GraphControl.setYAxisTitle("Eluent Composition");
        this.contentPane.m_GraphControl.setYAxisBaseUnit("%B", "%");
        this.contentPane.m_GraphControl.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane.m_GraphControl.setYAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControl.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControl.setAutoScaleY(true);
        this.contentPane.m_GraphControl.repaint();
        this.contentPane.m_GraphControlFlow.setYAxisTitle("Flow Rate");
        this.contentPane.m_GraphControlFlow.setYAxisBaseUnit("liter/min", "L/min");
        this.contentPane.m_GraphControlFlow.setYAxisRangeLimits(0.0, 10000.0);
        this.contentPane.m_GraphControlFlow.setYAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlFlow.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlFlow.setAutoScaleY(true);
        this.contentPane.m_GraphControlFlow.repaint();
        this.contentPane2 = new TopPanel2();
        this.contentPane2.setOpaque(true);
        this.contentPane2.jpanelStep6.setVisible(false);
        this.contentPane2.jbtnCalculate.addActionListener(this);
        this.contentPane2.jbtnNextStep.addActionListener(this);
        this.contentPane2.jbtnPreviousStep.addActionListener(this);
        this.contentPane2.jbtnPredict.addActionListener(this);
        this.contentPane2.jbtnHelp.addActionListener(this);
        this.contentPane2.m_GraphControl.setYAxisTitle("Eluent Composition");
        this.contentPane2.m_GraphControl.setYAxisBaseUnit("%B", "%");
        this.contentPane2.m_GraphControl.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane2.m_GraphControl.setYAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControl.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControl.setAutoScaleY(true);
        this.contentPane2.m_GraphControl.repaint();
        this.contentPane2.m_GraphControlFlow.setYAxisTitle("Flow Rate");
        this.contentPane2.m_GraphControlFlow.setYAxisBaseUnit("liter/min", "L/min");
        this.contentPane2.m_GraphControlFlow.setYAxisRangeLimits(0.0, 10000.0);
        this.contentPane2.m_GraphControlFlow.setYAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlFlow.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlFlow.setAutoScaleY(true);
        this.contentPane2.m_GraphControlFlow.repaint();
    }

    private void validateStartingComposition() {
        double dTemp = Float.valueOf(this.contentPane.jtxtInitialSolventComposition.getText()).floatValue();
        if (dTemp < 0.0) {
            dTemp = 0.0;
        }
        if (dTemp > 100.0) {
            dTemp = 100.0;
        }
        this.m_dStartingComposition = dTemp / 100.0;
        this.contentPane.jtxtInitialSolventComposition.setText(Float.toString((float)dTemp));
    }

    private void validateFinalComposition() {
        double dTemp = Float.valueOf(this.contentPane.jtxtFinalSolventComposition.getText()).floatValue();
        if (dTemp < 0.0) {
            dTemp = 0.0;
        }
        if (dTemp > 100.0) {
            dTemp = 100.0;
        }
        this.m_dEndingComposition = dTemp / 100.0;
        this.contentPane.jtxtFinalSolventComposition.setText(Float.toString((float)dTemp));
    }

    private void validateGradientTime() {
        double dTemp = Float.valueOf(this.contentPane.jtxtGradientTime.getText()).floatValue();
        if (dTemp < 0.1) {
            dTemp = 0.1;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dGradientTime = dTemp;
        this.contentPane.jtxtGradientTime.setText(Float.toString((float)this.m_dGradientTime));
    }

    private void validateFlowRate() {
        double dTemp = Float.valueOf(this.contentPane.jtxtFlowRate.getText()).floatValue();
        if (dTemp < 1.0E-9) {
            dTemp = 1.0E-9;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dFlowRate = dTemp;
        this.contentPane.jtxtFlowRate.setText(Float.toString((float)this.m_dFlowRate));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String strActionCommand = evt.getActionCommand();
        if (strActionCommand == "Help") {
            Globals.hbMainHelpBroker.setCurrentID("step-by-step");
            Globals.hbMainHelpBroker.setDisplayed(true);
        } else if (strActionCommand == "Next Step") {
            this.m_iStage = 2;
            this.contentPane2.jbtnCalculate.setText("Back-Calculate Profiles");
            this.contentPane2.jbtnCalculate.setEnabled(true);
            this.contentPane2.jlblIterationNumber.setText("1");
            this.contentPane2.jlblLastVariance.setText("");
            this.contentPane2.jlblPercentImprovement.setText("");
            this.contentPane2.jlblPhase.setText("I");
            this.contentPane2.jlblTimeElapsed.setText("");
            this.contentPane2.jlblVariance.setText("");
            this.contentPane2.jProgressBar.setString("");
            this.contentPane2.jProgressBar.setIndeterminate(false);
            this.contentPane2.jbtnNextStep.setEnabled(false);
            this.contentPane2.m_GraphControl.RemoveAllSeries();
            this.contentPane2.m_GraphControlFlow.RemoveAllSeries();
            this.contentPane2.jpanelStep6.setVisible(false);
            this.contentPane2.jpanelStep5.setVisible(true);
            double dVmMax = 0.0;
            int i = 0;
            while (i < Globals.dDeadTimeArray.length) {
                if (Globals.dDeadTimeArray[i][1] > dVmMax) {
                    dVmMax = Globals.dDeadTimeArray[i][1];
                }
                ++i;
            }
            this.contentPane2.tmOutputModel.getDataVector().clear();
            i = 0;
            while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0);
                objectArray[1] = this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1);
                Object[] newRow = objectArray;
                this.contentPane2.tmOutputModel.addRow(newRow);
                ++i;
            }
            this.m_vectCalSolutes.clear();
            i = 0;
            while (i < this.contentPane2.tmOutputModel.getRowCount()) {
                int iIndex = 0;
                int j = 0;
                while (j < Globals.CompoundNameArray.length) {
                    if (Globals.CompoundNameArray[j] == this.contentPane2.tmOutputModel.getValueAt(i, 0)) {
                        iIndex = j;
                        break;
                    }
                    ++j;
                }
                Object[] newSolute = new Object[]{iIndex, this.contentPane2.tmOutputModel.getValueAt(i, 1)};
                this.m_vectCalSolutes.add(newSolute);
                ++i;
            }
            this.m_dPlotXMax2 = (Double)this.m_vectCalSolutes.get(this.m_vectCalSolutes.size() - 1)[1] - dVmMax / this.m_dFlowRate;
            this.m_dtstep = this.m_dPlotXMax2 * 6.666666666666666E-4;
            int iIdealPlotIndex = this.contentPane2.m_GraphControl.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false);
            int iIdealPlotIndexFlow = this.contentPane2.m_GraphControlFlow.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false);
            this.m_iInterpolatedGradientSeries = this.contentPane2.m_GraphControl.AddSeries("Interpolated Gradient", new Color(255, 0, 0), 1, false);
            this.m_iGradientMarkerSeries = this.contentPane2.m_GraphControl.AddSeries("Gradient Markers", new Color(255, 0, 0), 1, true);
            this.m_iInterpolatedFlowSeries = this.contentPane2.m_GraphControlFlow.AddSeries("Interpolated Flow", new Color(255, 0, 0), 1, false);
            this.m_iFlowRateMarkerSeries = this.contentPane2.m_GraphControlFlow.AddSeries("Flow Rate Markers", new Color(255, 0, 0), 1, true);
            this.contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, 0.0, this.m_dStartingComposition * 100.0);
            this.contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, this.m_dGradientTime * 60.0, this.m_dEndingComposition * 100.0);
            this.contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, Math.max(this.m_dPlotXMax2, this.m_dGradientTime) * 60.0, this.m_dEndingComposition * 100.0);
            this.contentPane2.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, 0.0, this.m_dFlowRate / 1000.0);
            this.contentPane2.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, Math.max(this.m_dPlotXMax2, this.m_dGradientTime) * 60.0, this.m_dFlowRate / 1000.0);
            int iTotalDataPoints = this.m_vectCalSolutes.size();
            int iNumGradientDataPoints = (int)(0.7333333333333333 * (double)iTotalDataPoints);
            int iNumFlowDataPoints = iTotalDataPoints - iNumGradientDataPoints;
            if (iNumFlowDataPoints < 3) {
                iNumFlowDataPoints = 3;
                iNumGradientDataPoints = iTotalDataPoints - iNumFlowDataPoints;
            }
            this.m_dGradientArray = new double[iNumGradientDataPoints][2];
            this.m_dFlowRateArray = new double[iNumFlowDataPoints][2];
            this.m_dGradientArray[0][0] = 0.0;
            this.m_dGradientArray[0][1] = this.m_dStartingComposition;
            int i2 = 1;
            while (i2 < iNumGradientDataPoints) {
                this.m_dGradientArray[i2][0] = ((Double)this.m_vectCalSolutes.get(this.m_vectCalSolutes.size() - 1)[1] - dVmMax / this.m_dFlowRate) * ((double)i2 / ((double)iNumGradientDataPoints - 1.0));
                this.m_dGradientArray[i2][1] = Math.min(Math.max(this.m_dStartingComposition, (this.m_dEndingComposition - this.m_dStartingComposition) / this.m_dGradientTime * ((Double)this.m_vectCalSolutes.get(this.m_vectCalSolutes.size() - 1)[1] - dVmMax / this.m_dFlowRate) * ((double)i2 / ((double)iNumGradientDataPoints - 1.0)) + this.m_dStartingComposition), 1.0);
                ++i2;
            }
            i2 = 0;
            while (i2 < iNumFlowDataPoints) {
                this.m_dFlowRateArray[i2][0] = ((Double)this.m_vectCalSolutes.get(this.m_vectCalSolutes.size() - 1)[1] - dVmMax / this.m_dFlowRate) * ((double)i2 / ((double)iNumFlowDataPoints - 1.0));
                this.m_dFlowRateArray[i2][1] = this.m_dFlowRate;
                ++i2;
            }
            this.m_InterpolatedGradient = new InterpolationFunction(this.m_dGradientArray);
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            this.setContentPane(this.contentPane2);
            this.UpdateGraphs();
        } else if (strActionCommand == "Previous Step") {
            if (this.m_iStage == 2) {
                this.setContentPane(this.contentPane);
                if (this.task != null) {
                    this.task.cancel(true);
                }
                this.m_iStage = 1;
            } else if (this.m_iStage == 3) {
                if (this.taskPredict != null) {
                    this.taskPredict.cancel(true);
                }
                this.contentPane2.jpanelStep6.setVisible(false);
                this.contentPane2.jpanelStep5.setVisible(true);
                this.contentPane2.jbtnNextStep.setVisible(true);
                this.m_iStage = 2;
            }
        } else if (strActionCommand == "Calculate") {
            this.BackCalculate();
        } else if (strActionCommand == "Stop Calculations") {
            this.task.cancel(true);
        } else if (strActionCommand == "Next Step2") {
            this.contentPane2.tmPredictionModel.getDataVector().clear();
            int i = 0;
            while (i < this.contentPane.tmSelectCompounds.getRowCount()) {
                if (!((Boolean)this.contentPane.tmSelectCompounds.getValueAt(i, 1)).booleanValue()) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = this.contentPane.tmSelectCompounds.getValueAt(i, 0);
                    Object[] newRow = objectArray;
                    this.contentPane2.tmPredictionModel.addRow(newRow);
                }
                ++i;
            }
            this.contentPane2.jpanelStep5.setVisible(false);
            this.contentPane2.jpanelStep6.setVisible(true);
            this.contentPane2.jbtnNextStep.setVisible(false);
            this.contentPane2.jbtnPredict.setEnabled(true);
            this.contentPane2.jProgressBar2.setString("");
            this.contentPane2.jProgressBar2.setIndeterminate(false);
            ++this.m_iStage;
        } else if (strActionCommand == "Predict") {
            this.contentPane2.jbtnPredict.setEnabled(false);
            this.contentPane2.jProgressBar2.setIndeterminate(true);
            this.contentPane2.jProgressBar2.setStringPainted(true);
            this.contentPane2.jProgressBar2.setString("Please wait, calculating retention...");
            this.taskPredict = new TaskPredict();
            this.taskPredict.execute();
        } else if (strActionCommand == "Preloaded Values") {
            Frame[] frames = Frame.getFrames();
            PreloadedValuesDialog dlgPreloadedValues = new PreloadedValuesDialog(frames[0]);
            dlgPreloadedValues.setVisible(true);
            if (!dlgPreloadedValues.m_bOk) {
                return;
            }
            this.contentPane.jtxtInitialSolventComposition.setText("10.0");
            this.contentPane.jtxtFinalSolventComposition.setText("100.0");
            if (dlgPreloadedValues.m_iCondition == 0) {
                this.contentPane.jtxtFlowRate.setText("0.2");
                this.contentPane.jtxtGradientTime.setText("5");
            } else if (dlgPreloadedValues.m_iCondition == 1) {
                this.contentPane.jtxtFlowRate.setText("0.1");
                this.contentPane.jtxtGradientTime.setText("20");
            } else if (dlgPreloadedValues.m_iCondition == 2) {
                this.contentPane.jtxtFlowRate.setText("0.2");
                this.contentPane.jtxtGradientTime.setText("20");
            } else if (dlgPreloadedValues.m_iCondition == 3) {
                this.contentPane.jtxtFlowRate.setText("0.4");
                this.contentPane.jtxtGradientTime.setText("20");
            } else if (dlgPreloadedValues.m_iCondition == 4) {
                this.contentPane.jtxtFlowRate.setText("0.2");
                this.contentPane.jtxtGradientTime.setText("80");
            }
            int i = 0;
            while (i < this.contentPane.tmSelectCompounds.getRowCount()) {
                this.contentPane.tmSelectCompounds.setValueAt(false, i, 1);
                ++i;
            }
            i = 0;
            while (i < Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition].length) {
                this.contentPane.tmSelectCompounds.setValueAt(true, (int)Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition][i][0], 1);
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition][i][1], i, 1);
                ++i;
            }
            this.performValidations();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!Character.isDigit(e.getKeyChar()) && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f' && e.getKeyChar() != '.') {
            e.consume();
        }
        if (e.getKeyChar() == '\n') {
            this.performValidations();
        }
    }

    public void performValidations() {
        DecimalFormat formatter = new DecimalFormat("#0.0000");
        this.validateStartingComposition();
        this.validateFinalComposition();
        this.validateGradientTime();
        this.validateFlowRate();
        double dMax = 0.0;
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            double dValue = (Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1);
            if (dValue > dMax) {
                dMax = dValue;
            }
            ++i;
        }
        this.m_dPlotXMax = Math.max(this.m_dGradientTime * 1.2, dMax * 1.02);
        this.contentPane.m_GraphControl.RemoveAllSeries();
        this.contentPane.m_GraphControlFlow.RemoveAllSeries();
        int iIdealPlotIndex = this.contentPane.m_GraphControl.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false);
        int iIdealPlotIndexFlow = this.contentPane.m_GraphControlFlow.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false);
        this.contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, 0.0, this.m_dStartingComposition * 100.0);
        this.contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, this.m_dGradientTime * 60.0, this.m_dEndingComposition * 100.0);
        this.contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, this.m_dPlotXMax * 60.0, this.m_dEndingComposition * 100.0);
        this.contentPane.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, 0.0, this.m_dFlowRate / 1000.0);
        this.contentPane.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, this.m_dPlotXMax * 60.0, this.m_dFlowRate / 1000.0);
        this.contentPane.m_GraphControl.AutoScaleX();
        this.contentPane.m_GraphControl.AutoScaleY();
        this.contentPane.m_GraphControl.repaint();
        this.contentPane.m_GraphControlFlow.AutoScaleX();
        this.contentPane.m_GraphControlFlow.AutoScaleY();
        this.contentPane.m_GraphControlFlow.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidations();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.performValidations();
    }

    @Override
    public void autoScaleChanged(AutoScaleEvent event) {
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (arg0.getSource() == this.contentPane.tmSelectCompounds) {
            int row = arg0.getFirstRow();
            int column = arg0.getColumn();
            if (column == 1) {
                Boolean bNewValue = (Boolean)this.contentPane.tmSelectCompounds.getValueAt(row, 1);
                if (bNewValue.booleanValue()) {
                    Object[] newRow = new Object[]{Globals.CompoundNameArray[row], new Double(0.0)};
                    this.contentPane.tmMeasuredRetentionTimes.addRow(newRow);
                } else {
                    int numRows = this.contentPane.tmMeasuredRetentionTimes.getRowCount();
                    int i = 0;
                    while (i < numRows) {
                        if (this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0) == this.contentPane.tmSelectCompounds.getValueAt(row, 0)) {
                            this.contentPane.tmMeasuredRetentionTimes.removeRow(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else {
            arg0.getSource();
            TopPanel.SpecialTableModel cfr_ignored_0 = this.contentPane.tmMeasuredRetentionTimes;
        }
        this.performValidations();
        this.contentPane.m_GraphControl.removeAllLineMarkers();
        this.contentPane.m_GraphControlFlow.removeAllLineMarkers();
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            this.contentPane.m_GraphControl.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0));
            this.contentPane.m_GraphControlFlow.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0));
            ++i;
        }
        this.contentPane.m_GraphControl.repaint();
        this.contentPane.m_GraphControlFlow.repaint();
        int iNumDifferent = 0;
        int i2 = 0;
        while (i2 < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            double dValue = (Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 1);
            boolean bSame = false;
            int j = 0;
            while (j < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
                if (j != i2 && (Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(j, 1) == dValue) {
                    bSame = true;
                    break;
                }
                ++j;
            }
            if (!bSame) {
                ++iNumDifferent;
            }
            ++i2;
        }
        if (iNumDifferent >= 6) {
            this.contentPane.jbtnNextStep.setEnabled(true);
        } else {
            this.contentPane.jbtnNextStep.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateGraphs() {
        Object object = this.contentPane2.m_GraphControl.lockObject;
        synchronized (object) {
            Object object2 = this.contentPane2.m_GraphControlFlow.lockObject;
            synchronized (object2) {
                this.contentPane2.m_GraphControl.RemoveSeries(this.m_iInterpolatedGradientSeries);
                this.contentPane2.m_GraphControl.RemoveSeries(this.m_iGradientMarkerSeries);
                this.contentPane2.m_GraphControlFlow.RemoveSeries(this.m_iInterpolatedFlowSeries);
                this.contentPane2.m_GraphControlFlow.RemoveSeries(this.m_iFlowRateMarkerSeries);
                this.m_iInterpolatedGradientSeries = this.contentPane2.m_GraphControl.AddSeries("Interpolated Gradient", new Color(255, 0, 0), 1, false);
                this.m_iGradientMarkerSeries = this.contentPane2.m_GraphControl.AddSeries("Gradient Markers", new Color(255, 0, 0), 1, true);
                this.m_iInterpolatedFlowSeries = this.contentPane2.m_GraphControlFlow.AddSeries("Interpolated Flow", new Color(255, 0, 0), 1, false);
                this.m_iFlowRateMarkerSeries = this.contentPane2.m_GraphControlFlow.AddSeries("Flow Rate Markers", new Color(255, 0, 0), 1, true);
                int iNumPoints = 1000;
                int i = 0;
                while (i < iNumPoints) {
                    double dXPos = (double)i / (double)(iNumPoints - 1) * (this.m_dPlotXMax2 * 60.0);
                    this.contentPane2.m_GraphControl.AddDataPoint(this.m_iInterpolatedGradientSeries, dXPos, this.m_InterpolatedGradient.getAt(dXPos / 60.0) * 100.0);
                    this.contentPane2.m_GraphControlFlow.AddDataPoint(this.m_iInterpolatedFlowSeries, dXPos, this.m_InterpolatedFlowRate.getAt(dXPos / 60.0) / 1000.0);
                    ++i;
                }
                i = 0;
                while (i < this.m_dGradientArray.length) {
                    this.contentPane2.m_GraphControl.AddDataPoint(this.m_iGradientMarkerSeries, this.m_dGradientArray[i][0] * 60.0, this.m_dGradientArray[i][1] * 100.0);
                    ++i;
                }
                i = 0;
                while (i < this.m_dFlowRateArray.length) {
                    this.contentPane2.m_GraphControlFlow.AddDataPoint(this.m_iFlowRateMarkerSeries, this.m_dFlowRateArray[i][0] * 60.0, this.m_dFlowRateArray[i][1] / 1000.0);
                    ++i;
                }
                this.contentPane2.m_GraphControl.AutoScaleX();
                this.contentPane2.m_GraphControl.AutoScaleY();
                this.contentPane2.m_GraphControlFlow.AutoScaleX();
                this.contentPane2.m_GraphControlFlow.AutoScaleY();
                this.contentPane2.m_GraphControl.repaint();
                this.contentPane2.m_GraphControlFlow.repaint();
            }
        }
    }

    public void BackCalculate() {
        this.contentPane2.jbtnCalculate.setEnabled(false);
        this.contentPane2.jProgressBar.setIndeterminate(true);
        this.contentPane2.jProgressBar.setStringPainted(true);
        this.contentPane2.jProgressBar.setString("Please wait, optimization in progress...");
        this.task = new Task();
        this.task.execute();
    }

    public double CalcRetentionError(double dtstep) {
        DecimalFormat formatter = new DecimalFormat("#0.0000");
        double dRetentionError = 0.0;
        int iNumCompounds = this.m_vectCalSolutes.size();
        int iCompound = 0;
        while (iCompound < iNumCompounds) {
            double dIntegral = 0.0;
            double dtRFinal = 0.0;
            double dD = 0.0;
            double dTotalTime = 0.0;
            double dTotalDeadTime = 0.0;
            double dXPosition = 0.0;
            double[] dLastXPosition = new double[]{0.0, 0.0};
            double[] dLastko = new double[]{0.0, 0.0};
            double dXMovement = 0.0;
            Boolean bIsEluted = false;
            double dPhiC = 0.0;
            double dCurVal = 0.0;
            double t = 0.0;
            while (t <= (Double)this.m_vectCalSolutes.get(this.m_vectCalSolutes.size() - 1)[1] * 1.5) {
                dPhiC = this.m_InterpolatedGradient.getAt(dTotalTime - dIntegral);
                dCurVal = dtstep / Math.pow(10.0, this.m_IsocraticDataInterpolated[iCompound].getAt(dPhiC));
                double dt0 = this.m_Vm.getAt(dPhiC) / this.m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
                dXMovement = dCurVal / dt0;
                if (dXPosition >= 1.0) {
                    dD = (1.0 - dLastXPosition[0]) / (dXPosition - dLastXPosition[0]) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1];
                } else {
                    dLastXPosition[0] = dXPosition;
                    dLastXPosition[1] = dTotalDeadTime;
                }
                dTotalDeadTime += dXMovement * dt0;
                if (dXPosition >= 1.0) {
                    dtRFinal = (dD - dLastko[0]) / (dIntegral - dLastko[0]) * (dTotalTime - dLastko[1]) + dLastko[1];
                } else {
                    dLastko[0] = dIntegral;
                    dLastko[1] = dTotalTime;
                }
                dTotalTime += dtstep + dCurVal;
                dIntegral += dCurVal;
                if (dXPosition > 1.0 && !bIsEluted.booleanValue()) {
                    bIsEluted = true;
                    break;
                }
                dXPosition += dXMovement;
                t += dtstep;
            }
            if (bIsEluted.booleanValue()) {
                dRetentionError += Math.pow(dtRFinal - (Double)this.m_vectCalSolutes.get(iCompound)[1], 2.0);
                this.contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal), iCompound, 2);
                this.contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal - (Double)this.m_vectCalSolutes.get(iCompound)[1]), iCompound, 3);
            } else {
                dRetentionError += Math.pow((Double)this.m_vectCalSolutes.get(iCompound)[1], 2.0);
                this.contentPane2.tmOutputModel.setValueAt("Did not elute", iCompound, 2);
                this.contentPane2.tmOutputModel.setValueAt("-", iCompound, 3);
            }
            ++iCompound;
        }
        return dRetentionError;
    }

    public void UpdateTime(long starttime) {
        DecimalFormat timeformatter = new DecimalFormat("00");
        long currentTime = System.currentTimeMillis();
        long lNumSecondsPassed = (currentTime - starttime) / 1000L;
        long lNumDaysPassed = lNumSecondsPassed / 86400L;
        long lNumHoursPassed = (lNumSecondsPassed -= lNumDaysPassed * 86400L) / 3600L;
        long lNumMinutesPassed = (lNumSecondsPassed -= lNumHoursPassed * 3600L) / 60L;
        String strProgress2 = "";
        strProgress2 = String.valueOf(strProgress2) + timeformatter.format(lNumHoursPassed) + ":" + timeformatter.format(lNumMinutesPassed) + ":" + timeformatter.format(lNumSecondsPassed -= lNumMinutesPassed * 60L);
        this.contentPane2.jlblTimeElapsed.setText(strProgress2);
    }

    public void Calculate(Task task) {
        long starttime = System.currentTimeMillis();
        DecimalFormat formatter1 = new DecimalFormat("#0.000000");
        DecimalFormat formatter2 = new DecimalFormat("0.0000E0");
        DecimalFormat percentFormatter = new DecimalFormat("0.00");
        this.m_Vm = new InterpolationFunction(Globals.dDeadTimeArray);
        this.m_IsocraticDataInterpolated = new InterpolationFunction[this.contentPane2.tmOutputModel.getRowCount()];
        int i = 0;
        while (i < this.m_IsocraticDataInterpolated.length) {
            Integer iIndex = (Integer)this.m_vectCalSolutes.get(i)[0];
            this.m_IsocraticDataInterpolated[i] = new InterpolationFunction(Globals.IsocraticDataArray[iIndex]);
            ++i;
        }
        int iPhase = 1;
        int iIteration = 0;
        double dRetentionError = 0.0;
        double dLastRetentionError = 0.0;
        double dLastFullIterationError = 0.0;
        while (true) {
            double dNum;
            double dNum2;
            double dMaxChangeAtOnce;
            double dRetentionAccuracy;
            this.contentPane2.jlblIterationNumber.setText(Integer.valueOf(++iIteration).toString());
            dLastFullIterationError = dRetentionError;
            int iTimePoint = 0;
            while (iTimePoint < this.m_dGradientArray.length) {
                double dPhiStep = -0.005;
                dRetentionAccuracy = 1.0E-5;
                dRetentionError = 1.0;
                dMaxChangeAtOnce = 0.02;
                double dPhiGuess = this.m_dGradientArray[iTimePoint][1];
                double dLastPhiGuess = this.m_dGradientArray[iTimePoint][1];
                while (Math.abs(dPhiStep) > dRetentionAccuracy) {
                    this.m_dGradientArray[iTimePoint][1] = dPhiGuess;
                    this.m_InterpolatedGradient = new InterpolationFunction(this.m_dGradientArray);
                    dRetentionError = this.CalcRetentionError(this.m_dtstep);
                    this.UpdateTime(starttime);
                    double dNum3 = dRetentionError / (double)this.m_vectCalSolutes.size();
                    String str = dNum3 < 1.0E-4 ? formatter2.format(dNum3) : formatter1.format(dNum3);
                    this.contentPane2.jlblVariance.setText(str);
                    this.UpdateGraphs();
                    if (task.isCancelled()) {
                        return;
                    }
                    if (dLastRetentionError - dRetentionError > 0.0) {
                        if (dPhiGuess == 1.0 || dPhiGuess == 0.0 || dPhiGuess > dLastPhiGuess + dMaxChangeAtOnce || dPhiGuess < dLastPhiGuess - dMaxChangeAtOnce) {
                            dLastRetentionError = dRetentionError;
                            break;
                        }
                    } else {
                        if (Math.abs(dPhiStep / 2.0) <= dRetentionAccuracy) {
                            dPhiGuess -= dPhiStep;
                            dLastRetentionError = dRetentionError;
                            break;
                        }
                        dPhiStep = -dPhiStep / 2.0;
                    }
                    if ((dPhiGuess += dPhiStep) < 0.0) {
                        dPhiGuess = 0.0;
                    }
                    if (dPhiGuess > 1.0) {
                        dPhiGuess = 1.0;
                    }
                    dLastRetentionError = dRetentionError;
                }
                ++iTimePoint;
            }
            if (iPhase == 2) {
                iTimePoint = 0;
                while (iTimePoint < this.m_dFlowRateArray.length) {
                    double dFStep = -(this.m_dFlowRate / 100.0);
                    dRetentionAccuracy = this.m_dFlowRate / 100000.0;
                    dRetentionError = 1.0;
                    dMaxChangeAtOnce = this.m_dFlowRate / 20.0;
                    double dFGuess = this.m_dFlowRateArray[iTimePoint][1];
                    double dLastFGuess = this.m_dFlowRateArray[iTimePoint][1];
                    while (Math.abs(dFStep) > dRetentionAccuracy) {
                        this.m_dFlowRateArray[iTimePoint][1] = dFGuess;
                        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
                        dRetentionError = this.CalcRetentionError(this.m_dtstep);
                        this.UpdateTime(starttime);
                        double dNum4 = dRetentionError / (double)this.m_vectCalSolutes.size();
                        String str = dNum4 < 1.0E-4 ? formatter2.format(dNum4) : formatter1.format(dNum4);
                        this.contentPane2.jlblVariance.setText(str);
                        this.UpdateGraphs();
                        if (dLastRetentionError - dRetentionError > 0.0) {
                            if (dFGuess == 0.0 || dFGuess > dLastFGuess + dMaxChangeAtOnce || dFGuess < dLastFGuess - dMaxChangeAtOnce) {
                                dLastRetentionError = dRetentionError;
                                break;
                            }
                        } else {
                            if (Math.abs(dFStep / 2.0) <= dRetentionAccuracy) {
                                dFGuess -= dFStep;
                                dLastRetentionError = dRetentionError;
                                break;
                            }
                            dFStep = -dFStep / 2.0;
                        }
                        if ((dFGuess += dFStep) < 0.0) {
                            dFGuess = 0.0;
                        }
                        dLastRetentionError = dRetentionError;
                    }
                    ++iTimePoint;
                }
            }
            if (dLastFullIterationError != 0.0 && (dNum2 = (1.0 - dRetentionError / dLastFullIterationError) * 100.0) < 10.0 && dNum2 >= 0.0) {
                iPhase = 2;
                this.contentPane2.jlblPhase.setText("II");
            }
            String str = (dNum = dRetentionError / (double)this.m_vectCalSolutes.size()) == 0.0 ? "" : (dNum < 1.0E-4 ? formatter2.format(dNum) : formatter1.format(dNum));
            this.contentPane2.jlblLastVariance.setText(str);
            if (dLastFullIterationError == 0.0) continue;
            dNum = (1.0 - dRetentionError / dLastFullIterationError) * 100.0;
            this.contentPane2.jlblPercentImprovement.setText(String.valueOf(percentFormatter.format(dNum)) + "%");
            if (dNum < 1.0 && dNum >= 0.0) break;
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            RetentionPredictorApplet.this.Calculate(this);
            return null;
        }

        @Override
        public void done() {
            RetentionPredictorApplet.this.contentPane2.jbtnNextStep.setEnabled(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setIndeterminate(false);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setStringPainted(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setString("Optimization complete! Continue to next step.");
        }
    }

    class TaskPredict
    extends SwingWorker<Void, Void> {
        TaskPredict() {
        }

        @Override
        public Void doInBackground() {
            DecimalFormat formatter = new DecimalFormat("#0.000");
            int iIndex = 0;
            int iNumCompounds = RetentionPredictorApplet.this.contentPane.tmSelectCompounds.getRowCount();
            int iCompound = 0;
            while (iCompound < iNumCompounds) {
                if (!((Boolean)RetentionPredictorApplet.this.contentPane.tmSelectCompounds.getValueAt(iCompound, 1)).booleanValue()) {
                    if (RetentionPredictorApplet.this.taskPredict.isCancelled()) {
                        return null;
                    }
                    InterpolationFunction IsocraticData = new InterpolationFunction(Globals.IsocraticDataArray[iCompound]);
                    double dIntegral = 0.0;
                    double dtRFinal = 0.0;
                    double dD = 0.0;
                    double dTotalTime = 0.0;
                    double dTotalDeadTime = 0.0;
                    double dXPosition = 0.0;
                    double[] dLastXPosition = new double[]{0.0, 0.0};
                    double[] dLastko = new double[]{0.0, 0.0};
                    double dXMovement = 0.0;
                    Boolean bIsEluted = false;
                    double dPhiC = 0.0;
                    double dCurVal = 0.0;
                    double t = 0.0;
                    while (t <= (Double)RetentionPredictorApplet.this.m_vectCalSolutes.get(RetentionPredictorApplet.this.m_vectCalSolutes.size() - 1)[1] * 1.5) {
                        dPhiC = RetentionPredictorApplet.this.m_InterpolatedGradient.getAt(dTotalTime - dIntegral);
                        dCurVal = RetentionPredictorApplet.this.m_dtstep / Math.pow(10.0, IsocraticData.getAt(dPhiC));
                        double dt0 = RetentionPredictorApplet.this.m_Vm.getAt(dPhiC) / RetentionPredictorApplet.this.m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
                        dXMovement = dCurVal / dt0;
                        if (dXPosition >= 1.0) {
                            dD = (1.0 - dLastXPosition[0]) / (dXPosition - dLastXPosition[0]) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1];
                        } else {
                            dLastXPosition[0] = dXPosition;
                            dLastXPosition[1] = dTotalDeadTime;
                        }
                        dTotalDeadTime += dXMovement * dt0;
                        if (dXPosition >= 1.0) {
                            dtRFinal = (dD - dLastko[0]) / (dIntegral - dLastko[0]) * (dTotalTime - dLastko[1]) + dLastko[1];
                        } else {
                            dLastko[0] = dIntegral;
                            dLastko[1] = dTotalTime;
                        }
                        dTotalTime += RetentionPredictorApplet.this.m_dtstep + dCurVal;
                        dIntegral += dCurVal;
                        if (dXPosition > 1.0 && !bIsEluted.booleanValue()) {
                            bIsEluted = true;
                            break;
                        }
                        dXPosition += dXMovement;
                        t += RetentionPredictorApplet.this.m_dtstep;
                    }
                    if (bIsEluted.booleanValue()) {
                        RetentionPredictorApplet.this.contentPane2.tmPredictionModel.setValueAt(formatter.format(dtRFinal), iIndex, 1);
                    } else {
                        RetentionPredictorApplet.this.contentPane2.tmPredictionModel.setValueAt("Did not elute", iIndex, 1);
                    }
                    ++iIndex;
                }
                ++iCompound;
            }
            return null;
        }

        @Override
        public void done() {
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setIndeterminate(false);
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setStringPainted(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setString("Retention predictions complete.");
        }
    }
}

